/*
 * 
 */
package w83a.w83aDAO;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aBeans.W83aCentroTrabajoBean;
import w83a.w83aBeans.W83aCentroTrabajoCompletoBean;
import w83a.w83aDAO.w83aConstantesBD.W83aCentroTrabajoCompletoVistaBD;
import w83a.w83aDAO.w83aConstantesBD.W83aCentroTrabajoVistaBD;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aDateUtil;



// TODO: Auto-generated Javadoc
/**
 * The Interface W83bIPreavisosDAO.
 * @author a
 */
public class W83aCentroTrabajoDAO implements W83aICentroTrabajoDAO{
	
	public java.util.List buscarCentroTrabajo(W83aCentroTrabajoBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aCentroTrabajoVistaBD.codcentro).append(", ");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.cifnif).append(") AS ").append(W83aCentroTrabajoVistaBD.cifnif).append(",");
		strSql.append(W83aCentroTrabajoVistaBD.tipcifnif).append(", ");
		strSql.append(W83aCentroTrabajoVistaBD.nCentro).append(", ");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.razonsocial).append(") AS ").append(W83aCentroTrabajoVistaBD.razonsocial).append(",");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.domicilio).append(") AS ").append(W83aCentroTrabajoVistaBD.domicilio).append(",");
		strSql.append(W83aCentroTrabajoVistaBD.codTerritorio).append(", ");
		strSql.append(W83aCentroTrabajoVistaBD.codMunicipio).append(", ");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.municipio).append(") AS ").append(W83aCentroTrabajoVistaBD.municipio).append(",");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.territorio).append(") AS ").append(W83aCentroTrabajoVistaBD.territorio).append(",");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.territorio_eusk).append(") AS ").append(W83aCentroTrabajoVistaBD.territorio_eusk).append(",");
		strSql.append(W83aCentroTrabajoVistaBD.codpostal).append(", ");
		strSql.append(W83aCentroTrabajoVistaBD.cnae);
		
		strSql.append(" FROM w83b.").append(W83aCentroTrabajoVistaBD.nombreVista);

		boolean where = false;
		
		if(StringUtils.isNotEmpty(param.getCodCentroTrabajo())){
			strSql.append(" WHERE ");
			where = true;
			strSql.append(" ").append(W83aCentroTrabajoVistaBD.codcentro).append(" = ?");
			params.add(new Integer(param.getCodCentroTrabajo()));
		}else{
			if(StringUtils.isNotEmpty(param.getCifnif())){
				if(!where){
					strSql.append(" WHERE ");
					where = true;
				}else{
					strSql.append(" AND ");				
				}
				strSql.append(" ").append(W83aCentroTrabajoVistaBD.cifnif).append(" = ?");
				params.add(param.getCifnif().toUpperCase());
			}
			if(StringUtils.isNotEmpty(param.getNumCentro())){
				if(!where){
					strSql.append(" WHERE ");
					where = true;
				}else{
					strSql.append(" AND ");				
				}
				strSql.append(" ").append(W83aCentroTrabajoVistaBD.nCentro).append(" = ?");
				params.add(param.getNumCentro());
			}
			if(StringUtils.isNotEmpty(param.getRazonSocial())){
				if(!where){
					strSql.append(" WHERE ");
					where = true;
				}else{
					strSql.append(" AND ");				
				}
				strSql.append(" (UPPER(").append(W83aCentroTrabajoVistaBD.razonsocial).append(") like ?");
				params.add(new StringBuffer(W83aClsConstantes.CUARENTA).append("%").append(param.getRazonSocial().toUpperCase())
						.append("%").toString());
				strSql.append(" OR ");				
				strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.razonsocialscaracteres).append(") like ?)");
				params.add(new StringBuffer(W83aClsConstantes.CUARENTA).append("%").append(param.getRazonSocial().toUpperCase())
						.append("%").toString());
			}
		}

		/*if(!param.getIdColumna().equalsIgnoreCase(""))
		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());			
		
		*/
		List listaCentroTrabajo = W83aDataBase.executeQuery(strSql.toString(),params,W83aCentroTrabajoBean.class,param.getUsuarioBean(), null);
		
		return listaCentroTrabajo;		
	}
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public int contarCentroTrabajo(w83a.w83aBeans.W83aCentroTrabajoBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT count(");
		strSql.append(W83aCentroTrabajoVistaBD.codcentro);
		strSql.append(")");
		
		strSql.append(" FROM w83b.").append(W83aCentroTrabajoVistaBD.nombreVista);
		
		boolean where = false;
		
		if(StringUtils.isNotEmpty(param.getCodCentroTrabajo())){
			strSql.append(" WHERE ");
			where = true;
			strSql.append(" ").append(W83aCentroTrabajoVistaBD.codcentro).append(" = ?");
			params.add(new Integer(param.getCodCentroTrabajo()));
		}
		if(StringUtils.isNotEmpty(param.getCifnif())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" ").append(W83aCentroTrabajoVistaBD.cifnif).append(" = ?");
			params.add(param.getCifnif().toUpperCase());
		}
		if(StringUtils.isNotEmpty(param.getRazonSocial())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.razonsocial).append(") like ?");
			params.add(new StringBuffer(W83aClsConstantes.CUARENTA).append("%").append(param.getRazonSocial().toUpperCase())
					.append("%").toString());
		}
		
		
		
		List listaCentroTrabajo = W83aDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());
		
		return Integer.parseInt(listaCentroTrabajo.get(0).toString());		
	}
	
	public java.util.List detalleCentroTrabajo(String cifnif, String nCentroTrabajo,String idioma) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.cifNif);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.cifNif);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.tipoCif);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.nCentroTrabajo);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codCentro);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.razonSocial);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.domicilio);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codPostal);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codTerritorio);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codMunicipio);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.localidad);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codComarca);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.comarca);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.telefono);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.fax);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.nombreComercial);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.domicilioFiscal);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codTerritorioFiscal);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codMunicipioFiscal);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codPostalFiscal);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codCnae);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.cnae);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codSector);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codRegJurid);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.numTrabajadores);
		strSql.append(", ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.codBaja);
		strSql.append(", TO_CHAR(");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.fecBaja);
		strSql.append(",?) AS ").append(W83aCentroTrabajoCompletoVistaBD.fecBaja);
		strSql.append(", TO_CHAR(");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83aCentroTrabajoCompletoVistaBD.fecUltimaActualizacion);
		strSql.append(",?) AS ").append(W83aCentroTrabajoCompletoVistaBD.fecUltimaActualizacion);
		strSql.append(", ");
		params.add(W83aDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83aCentroTrabajoCompletoVistaBD.observaciones);
		strSql.append(" FROM w83b.").append(W83aCentroTrabajoCompletoVistaBD.nombreVista);
		strSql.append(" WHERE ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.cifNif).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83aCentroTrabajoCompletoVistaBD.nCentroTrabajo).append(" = ?");
		params.add(cifnif);
		params.add(nCentroTrabajo);
		
		List listaDatosParametros = W83aDataBase.executeQuery(strSql.toString(),params,W83aCentroTrabajoCompletoBean.class,null,null);
		
		return listaDatosParametros;
	}
	
	//select * from W83BCENTROTRABAJODOCUMENTACION WHERE (UPPER (razonsocial) LIKE '%DEL%' OR UPPER (razonsocialscaracteres) LIKE '%DEL%')
	//order by cifnif,ncentrotrabajo
	public java.util.List buscarCentroTrabajoDocumentacion(W83aCentroTrabajoBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83aCentroTrabajoVistaBD.codcentro).append(", ");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.cifnif).append(") AS ").append(W83aCentroTrabajoVistaBD.cifnif).append(",");
		strSql.append(W83aCentroTrabajoVistaBD.tipcifnif).append(", ");
		strSql.append(W83aCentroTrabajoVistaBD.nCentro).append(", ");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.razonsocial).append(") AS ").append(W83aCentroTrabajoVistaBD.razonsocial).append(",");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.domicilio).append(") AS ").append(W83aCentroTrabajoVistaBD.domicilio).append(",");
		strSql.append(W83aCentroTrabajoVistaBD.codTerritorio).append(", ");
		strSql.append(W83aCentroTrabajoVistaBD.codMunicipio).append(", ");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.municipio).append(") AS ").append(W83aCentroTrabajoVistaBD.municipio).append(",");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.territorio).append(") AS ").append(W83aCentroTrabajoVistaBD.territorio).append(",");
		strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.territorio_eusk).append(") AS ").append(W83aCentroTrabajoVistaBD.territorio_eusk).append(",");
		strSql.append(W83aCentroTrabajoVistaBD.codpostal).append(", ");
		strSql.append(W83aCentroTrabajoVistaBD.cnae);
		
		strSql.append(" FROM w83b.").append(W83aCentroTrabajoVistaBD.nombreVistaDocumentacion);

		boolean where = false;
		
		if(StringUtils.isNotEmpty(param.getCodCentroTrabajo())){
			strSql.append(" WHERE ");
			where = true;
			strSql.append(" ").append(W83aCentroTrabajoVistaBD.codcentro).append(" = ?");
			params.add(new Integer(param.getCodCentroTrabajo()));
		}else{
			if(StringUtils.isNotEmpty(param.getCifnif())){
				if(!where){
					strSql.append(" WHERE ");
					where = true;
				}else{
					strSql.append(" AND ");				
				}
				strSql.append(" ").append(W83aCentroTrabajoVistaBD.cifnif).append(" = ?");
				params.add(param.getCifnif().toUpperCase());
			}
			if(StringUtils.isNotEmpty(param.getNumCentro())){
				if(!where){
					strSql.append(" WHERE ");
					where = true;
				}else{
					strSql.append(" AND ");				
				}
				strSql.append(" ").append(W83aCentroTrabajoVistaBD.nCentro).append(" = ?");
				params.add(param.getNumCentro());
			}
			if(StringUtils.isNotEmpty(param.getRazonSocial())){
				if(!where){
					strSql.append(" WHERE ");
					where = true;
				}else{
					strSql.append(" AND ");				
				}
				strSql.append(" (UPPER(").append(W83aCentroTrabajoVistaBD.razonsocial).append(") like ?");
				params.add(new StringBuffer(W83aClsConstantes.CUARENTA).append("%").append(param.getRazonSocial().toUpperCase())
						.append("%").toString());
				strSql.append(" OR ");				
				strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.razonsocialscaracteres).append(") like ?)");
				params.add(new StringBuffer(W83aClsConstantes.CUARENTA).append("%").append(param.getRazonSocial().toUpperCase())
						.append("%").toString());
			}
		}

		/*if(!param.getIdColumna().equalsIgnoreCase(""))
		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());			
		
		*/
		List listaCentroTrabajo = W83aDataBase.executeQuery(strSql.toString(),params,W83aCentroTrabajoBean.class,param.getUsuarioBean(), null);
		
		return listaCentroTrabajo;		
	}
	public int contarCentroTrabajoDocumentacion(w83a.w83aBeans.W83aCentroTrabajoBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83aClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT count(");
		strSql.append(W83aCentroTrabajoVistaBD.codcentro);
		strSql.append(")");
		
		strSql.append(" FROM w83b.").append(W83aCentroTrabajoVistaBD.nombreVistaDocumentacion);
		
		boolean where = false;
		
		if(StringUtils.isNotEmpty(param.getCodCentroTrabajo())){
			strSql.append(" WHERE ");
			where = true;
			strSql.append(" ").append(W83aCentroTrabajoVistaBD.codcentro).append(" = ?");
			params.add(new Integer(param.getCodCentroTrabajo()));
		}
		if(StringUtils.isNotEmpty(param.getCifnif())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" ").append(W83aCentroTrabajoVistaBD.cifnif).append(" = ?");
			params.add(param.getCifnif().toUpperCase());
		}
		if(StringUtils.isNotEmpty(param.getRazonSocial())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" UPPER(").append(W83aCentroTrabajoVistaBD.razonsocial).append(") like ?");
			params.add(new StringBuffer(W83aClsConstantes.CUARENTA).append("%").append(param.getRazonSocial().toUpperCase())
					.append("%").toString());
		}
		
		
		
		List listaCentroTrabajo = W83aDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());
		
		return Integer.parseInt(listaCentroTrabajo.get(0).toString());		
	}
	
}
